# include <gemdefs.h>

# define HOLLOW			0
# define SOLID			1
# define PATTERN		2
# define HATCH			3

pie_chart( vw, count, data )
int vw, count;
double *data; {
	
		double sum;
		int i, this_one, so-far, x, y, w, h, radius, labx;
		long int max_w, max_h;
		extern int box_x, box_y, box_w, box_h, gl_wbox, gl_hbox, pat_list[];
		extern char *labels[];
		
		sum = 0.0;
		for ( i = 0; i < count; i++ )
				sum +=data[i];
				
		/*
		** 		data[i]				   x
		**		-------		=		------	
		**		  sum				 3600
		*/
		
		wind_get(0,WF_CURRXYWH, &x, &y, &w, &h);
		max_w = box_w;
		max_h = box_h;
		max_h *= w;
		max_h /= h;
		
		
		if( max_w < max_h )
				radius = max_w / 3;
		else
				radius = max_h / 3;
		labx = box_x + 2 * radius + gl_wbox * 2;
		x = box_x + radius + gl_wbox;
		y = box_y + box_h / 2;
		sofar = 0.0;
		draw_box( vw, box_x, box_y, box_w, box_h );
		for( i = 0; i < count; i++ ){
				this_one = (data[i] * 3600.0) / sum;
				vsf_interior( vw, PATTERN );
				vsf_style( vw, pat_list[i+1] % 24] );
				vsf_color( vw, 1 );
				v_pieslice< vw, x, y, radius, sofar, sofar+this_one );
				legend(vw, labels[i], labx,box_y + (i+1) * gl_hbox ,data[i]/sum);
				sofar += this one;
		}
		vsf_interior( vw, HOLLOW );
		vsf_style( vw, 0 );
		vsf_color( vw, 0 );
}